//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;
using System.Net;
using System.Net.Sockets;

namespace ProfilingSamples
{
	public class UdpMain 
	{
		private string server;
		private int port;
		UdpMain(string server, int port)
		{
			this.server = server;
			this.port = port;
		}
		void TestThread()
		{
			Socket s = null;
			try
			{
				IPAddress address = Dns.Resolve(server).AddressList[0];
				IPEndPoint remoteEP = new IPEndPoint(address, port);
				EndPoint trEP = (EndPoint)remoteEP;

				s = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

				Console.WriteLine("Poczono z serwerem {0}", server);

				byte[] writeBuffer = new byte[2048];
				byte[] readBuffer = new byte[2048];
				int nTransmitted;
				int nReceived;
				int nTotalReceived;

				while(true)
				{
					nTransmitted = s.SendTo(writeBuffer, 0, writeBuffer.Length, SocketFlags.None, remoteEP);
					Console.WriteLine("Wysano: {0}", nTransmitted);
					nReceived = 0;
					nTotalReceived = 0;
					while(nTotalReceived < nTransmitted)
					{
						Thread.Sleep(100);
						nReceived = s.ReceiveFrom(readBuffer, nReceived, nTransmitted - nTotalReceived, SocketFlags.None, ref trEP);
						Console.WriteLine("Odebrano: {0}", nTransmitted);
						nTotalReceived += nReceived;
					}
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
			finally
			{
				Console.WriteLine("TestThread finally");
				if(s != null)
					s.Close();
			}
		}
		static void Main(string [] args)
		{
			// Echo na porcie 7.
			UdpMain m = new UdpMain("JILAD", 7);
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}